/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.ast.util;

import icyllis.annotations.NotNull;
import icyllis.flexmark.ast.ImageRef;
import icyllis.flexmark.ast.LinkRef;
import icyllis.flexmark.ast.RefNode;
import icyllis.flexmark.ast.Reference;
import icyllis.flexmark.parser.Parser;
import icyllis.flexmark.util.ast.KeepType;
import icyllis.flexmark.util.ast.Node;
import icyllis.flexmark.util.ast.NodeRepository;
import icyllis.flexmark.util.data.DataHolder;
import icyllis.flexmark.util.data.DataKey;
import icyllis.flexmark.util.sequence.Escaping;
import java.util.HashSet;
import java.util.Set;

public class ReferenceRepository
extends NodeRepository<Reference> {
    public ReferenceRepository(DataHolder options) {
        super(Parser.REFERENCES_KEEP.get(options));
    }

    @Override
    @NotNull
    public DataKey<ReferenceRepository> getDataKey() {
        return Parser.REFERENCES;
    }

    @Override
    @NotNull
    public DataKey<KeepType> getKeepDataKey() {
        return Parser.REFERENCES_KEEP;
    }

    @Override
    @NotNull
    public String normalizeKey(@NotNull CharSequence key) {
        return Escaping.normalizeReference(key, true);
    }

    @Override
    @NotNull
    public Set<Reference> getReferencedElements(Node parent) {
        HashSet<Reference> references = new HashSet<Reference>();
        this.visitNodes(parent, value -> {
            Reference reference;
            if (value instanceof RefNode && (reference = ((RefNode)value).getReferenceNode(this)) != null) {
                references.add(reference);
            }
        }, LinkRef.class, ImageRef.class);
        return references;
    }
}

